import os
import json
import operator
import functools
from collections import defaultdict


VALID_ADD_INCOME_SOURCES = ["Alimony", "Annuity", "ChildSupport", "DisabilityInsurance", "PassiveIncome",
                          "RideShare", "SSI", "Trust", "Other"]
VALID_ADD_INCOME_PERIODS = ["Hourly", "Weekly", "BiWeekly", "SemiMonthly", "Monthly", "Yearly"]

class FileUtils:

    @staticmethod
    def get_file_names(prefix=""):
        file_list = []        
        for root, dirs, files in os.walk(prefix):
            for f in files:
                local_path = os.path.join(root, f)
                file_list.append(local_path)

        return file_list   

class BuildPayload:

    @staticmethod
    def build(row, verifications=None, print_unformatted_payload=False):
        infinitedict = lambda: defaultdict(infinitedict)
        app = infinitedict()
        for k in row:
            if row[k]:
                keys = k.split("__")
                lastplace = functools.reduce(operator.getitem, keys[:-1], app)                    
                lastplace[keys[-1]] = row[k]

        if print_unformatted_payload:
            print("UNFORMATTED PAYLOAD:")
            print(json.dumps(app, indent=2))  # print the dictionary prior to the formatting below

        for ver in verifications:
            app["verifications"][ver] = [{"belongs_to": "application"}]        

        for i in range(1,3):  # for applicant1 and applicant2
            if "first_name" in app["applicants"][f"applicant{i}"]:    
                applicant = app["applicants"][f"applicant{i}"]
                
                # Engulf the employment_info object in a list/array (for applicant1 and applicant2):
                employment_info_inner_obj = applicant["employment_info"].items()                    
                applicant["employment_info"] = []
                applicant["employment_info"].append(dict(employment_info_inner_obj))
            
                # Engulf the address_info object in a list/array (for applicant1 and applicant2):
                address_info_inner_obj = applicant["address_info"].items()
                applicant["address_info"] = []
                applicant["address_info"].append(dict(address_info_inner_obj))

                # Engulf the additional_incomes object in a list (for applicants)
                if "additional_incomes" in applicant:
                    additional_incomes_inner_obj = applicant["additional_incomes"].items()
                    applicant["additional_incomes"] = []
                    applicant["additional_incomes"].append(dict(additional_incomes_inner_obj))

                # Format the verifications that were ported in from the csv:  
                verifications_inner_obj = applicant["verifications"].items()
                for k, v in verifications_inner_obj:
                    if v.lower() == "true":
                        verification_data = {"belongs_to": f"applicant{i}"}
                        if k in app["verifications"].keys():
                            app["verifications"][k].append(verification_data) 
                        else:
                            app["verifications"][k] = [verification_data]                        

                # Delete the verifications list under the applicant as it is now listed below in the application verifications list
                del applicant["verifications"]

                # Add services
                if not app["services"]:
                    app["services"] = ["extract", "verify"]

            # If applicant first_name is not present
            else:
                del app["applicants"][f"applicant{i}"]
            # *** Notice that this will delete the entire applicant if there is no first_name 

        # Change formats from string to booleans and floats
        for k in app["applicants"].keys():
            if "employment_info" in app["applicants"][k]:
                app["applicants"][k]["employment_info"][0]["is_current"] = True
                app["applicants"][k]["employment_info"][0]["income"]["amount"] = \
                    float(app["applicants"][k]["employment_info"][0]["income"]["amount"])

            if "address_info" in app["applicants"][k]:
                app["applicants"][k]["address_info"][0]["is_current"] = True

            if "additional_incomes" in app["applicants"][k]:
                # print(json.dumps(app, indent=2))
                if "source" not in app["applicants"][k]["additional_incomes"][0] or \
                        app["applicants"][k]["additional_incomes"][0]["source"] not in VALID_ADD_INCOME_SOURCES:
                    app["applicants"][k]["additional_incomes"][0]["source"] = "Other"
                if app["applicants"][k]["additional_incomes"][0]["income"]["period"] not in VALID_ADD_INCOME_PERIODS:
                    app["applicants"][k]["additional_incomes"][0]["income"]["period"] = "Monthly"
                app["applicants"][k]["additional_incomes"][0]["income"]["amount"] = \
                    float(app["applicants"][k]["additional_incomes"][0]["income"]["amount"])

        # Convert vehicle info values to float
        if "vehicle_info" in app:
            for k in app["vehicle_info"]:
                if k in ["year", "odometer", "selling_price"]:
                    if "." in app["vehicle_info"][k]:
                        app["vehicle_info"][k] = float(app["vehicle_info"][k])
                    else:
                        app["vehicle_info"][k] = int(app["vehicle_info"][k])

        return app
